/*=======================================================================
Project: OMFXOR
Module:  omfxor.c
Purpose: decode/encode the encoded part of the OMF pilot files
Notice:  This program is based on a program called OMFEDIT and some
	 hacking done by David Bollinger.
	 His Compuserve address is: 72510,3623
	 Use however you like, but hold us blameless...
Author:  Benjamin Mathews: Compuserve address: 71022,1746
Created: 10/26/94

Once you edit the output file to your specs, run it back through this
program to change it back to a valid pilot file. Rember, keep a backup
of your pilot files!

What follows is table showing the structure of the unencoded file.
(i.e. What you get after you run the file through this program.)
Thanks to David Bollinger for this!
---cut-here---
PILOT DATA INTERPRETATION: (very tentative)

(obviously, it would be nice to wrap this into a structure)

Decimal                                                         Interpret
Offset     Type    Meaning                                      Confidence
-------    ----    -----------------------------------------    ----------
000-003            always zero?
004-019    byte    name                                         high+
022-023    int     wins                                         high+
024-025    int     losses                                       high+
026        byte    rank                                         high
028      -+        arm power/leg power                          low
029       |bit     leg power/arm speed                          low
030       |pack    leg speed/armor                              low
031      -+        stun resitance                               low
040-043    long    money (in K$)                                high+
044        byte    second body color                            high
045        byte    third body color                             high
046        byte    main body color                              high
047-059    byte    tournament filename                          high
060-090    byte    tournament description                       med
091-103    byte    tournament picture filename                  high
260-262            changes when arm/leg speed/power changes?    low-
263-1399           god only knows (encoded)
1400-1559          elam only knows (not encoded)
1560(?)-EOF        pilot picture bitmap, format unknown         low-
--------------------------------------------------------------------------
Limitations:
The count of 1400 encoded bytes is PROBABLY right, but...
Fortunately, due to XOR encoding, we can decode/encode a few too many/too
few bytes and everything else still works.
The bitmap does not APPEAR to be encoded, just a wacky format.

Hint (for what it's worth):  the bitmap format MAY be a series of 3
   ints (maybe offsets and counts) followed by the actual pixel data
   for each line, variable width lines.  If you want to make your own
   bitmaps you'll need to figure this out.
This is left as an exercise for the reader, there will be a test at
   the end of the semester  :)
---cut-here----------------------------------------------------------------*/

//=========
// includes
//---------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//========
// defines
//--------
#define MAX_FILESIZE           8192          // rough guess to avoid overrun
#define CODED_SIZE             1400          // # of coded bytes, roughly

//===================
// typedefs & structs
//-------------------
typedef unsigned char uchar;
typedef unsigned int uint;

//===========
// prototypes
//-----------
int  LoadPilot(char *filename);
void EnDeCode(void);
int  DumpPilot(char *filename);
void Usage(char *msg);

//========
// globals
//--------
char  pilotfile[13];
char  outputfile[13];
uchar pilot[MAX_FILESIZE];
int   filesize;

//============================================================================
main(int argc, char *argv[])
   {
   if (argc < 3)
      Usage("Usage:  OMFXOR <pilotfile> <outputfile>\n");
   strncpy(pilotfile, argv[1], 12);
   strncpy(outputfile, argv[2], 12);
   //=======================
   // load the original file
   //-----------------------
   if (LoadPilot(pilotfile))
      Usage("Error reading pilot file.\n");

   //=========================
   // dump the decoded version
   //-------------------------
   if (DumpPilot(outputfile))
      Usage("Error writing dump file.\n");

   printf("Done.\n");
   return 0;
   }

//============================================================================
int LoadPilot(char *filename)
   {
   FILE *in;
   uint ch;
   uchar *pptr=pilot;

   if ((in=fopen(filename,"rb")) == NULL)
      return 1;

   printf("Loading...\n");

   filesize = 0;
   ch = fgetc(in);
   while (!feof(in))
      {
      *pptr++ = ch;
      if (++filesize >= MAX_FILESIZE)        // avoid overrun
	 {
	 fclose(in);
	 return 1;
	 }
      ch = fgetc(in);
      }
   fclose(in);

   EnDeCode();
   return 0;
   }

//============================================================================
// XOR coding is reflexive, can use same routine for encode/decode
//----------------------------------------------------------------------------
void EnDeCode(void)
   {
   register int i;
   uchar *pptr=pilot, key=0xac;

   for (i=CODED_SIZE; i>=0; i--)
      *pptr++ ^= key++;
   }

//============================================================================
// you can use the decoded dump file to figure out other data values, maybe?
//----------------------------------------------------------------------------
int DumpPilot(char *filename)
   {
   FILE *out;
   register int i;
   uchar *pptr=pilot;

   if ((out=fopen(filename,"wb")) == NULL)
      return 1;

   printf("Dumping...\n");

   for (i=filesize; i>=0; i--)
      fputc((int)*pptr++, out);

   fclose(out);
   return 0;
   }

//============================================================================
void Usage(char *msg)
   {
   puts(msg);
   exit(0);
   }

//============================================================================
